	clear all
	clc
	% Example 7.10
	lw = 2;
	fs = 16;
	fn = 'times';
	Wc = 28000;	% Requirements for the highpass filter
	Ws = 20000;
	Amax =  0.28029;
	Amin = 40;
	% We choose the transformation angular frequency WI = Wc
	WI = Wc;
	Omegac = Wc;				% Omegac = WI^2/Wc = Wc
	Omegas = WI^2/Ws;
	% Synthesis of lowpass filter (Cauer)
	NLP = CA_ORDER_S(Omegac, Omegas, Amax, Amin);
	NLP = 5;
	[GLP, ZLP, ZLPr, PLP, Wnew] = CA_POLES_S(Omegac, Omegas, Amax, Amin, NLP)
	QLP = -abs(PLP)./(2*real(PLP))
	figure(1)
	W = linspace(10, 100000, 1000);
	H = PZ_2_FREQ_S(GLP, ZLP, PLP, W);
	Att = MAG_2_ATT(H);
	Taug = PZ_2_TG_S(GLP, ZLP, PLP, W);	
	subplot('position', [0.08 0.4 0.83 0.5]);
	axis_Amax = 60; axis_Tg_max = 6*10^-4;	
	PLOT_ATT_TG_S(Att, Taug, W, axis_Amax, axis_Tg_max); hold on
	%	set(gca,'FontName', fn,'FontSize', fs);
	%	xtick([0:10000:100000])
	text(45000, 0.35*10^-3,'Attenuation','FontName',fn,'FontSize',fs);
	text(2000, 0.2*10^-3,'Group Delay','FontName',fn,'FontSize',fs);
	
	% Transform LP to HP filter
	[Ghp, Zhp, Php] = PZ_2_HP_S(GLP, ZLP, PLP, WI^2)
	
	figure(2)
	PLOT_PZ_S(Zhp, Php, Wc, Ws, -60000, 5000, 40000)
	
	figure(3)	
	W = linspace(10, 100000, 1000);
	H = PZ_2_FREQ_S(Ghp, Zhp, Php, W);
	Att = MAG_2_ATT(H);
	%	Qhp = -abs(Php)./(2*real( Php))
	Taug = PZ_2_TG_S(Ghp, Zhp, Php, W);
	
	subplot('position', [0.08 0.4 0.83 0.5]);
	axis_Amax = 60; axis_Tg_max = 6*10^-4;	
	PLOT_ATT_TG_S(Att, Taug, W, axis_Amax, axis_Tg_max);hold on
	%	set(gca,'FontName', fn,'FontSize', fs);
	%	xtick([0:10000:100000])
	text(2000, 0.35*10^-3,'Attenuation','FontName',fn,'FontSize',fs);
	text(35000, 0.25*10^-3,'Group Delay','FontName',fn,'FontSize',fs);

